<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:apco-alarm="http://www.apcointl.com/new/commcenter911/external-alarm.xsd" xmlns:em="http://niem.gov/niem/domains/emergencyManagement/2.0" xmlns:nc="http://niem.gov/niem/niem-core/2.0" exclude-result-prefixes="NonHtml apco-alarm em nc" xmlns:NonHtml="http://www.progress.com/StylusStudio/NonHtml">
<xsl:output method="html"/>

<xsl:template match="/">
	<p xmlns:apco-alarm="http://www.apcointl.com/new/commcenter911/external-alarm.xsd">
		<html>
			<body/>
		</html>
	</p>
	<p>
		<font face="Arial" size="4">
			<strong>
				<u>Alarm Message</u>
			</strong>
		</font>
	</p>
	<p>
		<table width="100%" border="1">
			<tbody>
				<tr>
					<td width="50%">Alarm Type</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmEvent/em:AlarmEventCategoryText"/>
					</td>
				</tr>
				<tr>
					<td width="50%">Message Date/Time</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmEvent/nc:ActivityDate/nc:DateTime"/>
					</td>
				</tr>
				<tr>
					<td width="50%">Message Type</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmEvent/nc:ActivityCategoryText"/>
					</td>
				</tr>
			</tbody>
		</table>
	</p>
	<p>
		<font face="Arial CYR" size="4">
			<u>
				<strong>Message Status</strong>
			</u>
		</font>
	</p>
	<p>
		<table width="100%" border="1">
			<tbody>
				<tr>
					<td width="50%">Status Code</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmEvent/nc:ActivityStatus/nc:StatusText"/>
					</td>
				</tr>
				<tr>
					<td width="50%">Status Description</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmEvent/nc:ActivityStatus/nc:StatusDescriptionText"/>
					</td>
				</tr>
			</tbody>
		</table>
	</p>
	<p>
		<font face="Arial CYR" size="4">
			<u>
				<strong>Monitoring Station</strong>
			</u>
		</font>
	</p>
	<p>
		<table width="100%" border="1">
			<tbody>
				<tr>
					<td width="50%">CS Event Number</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmEvent/nc:ActivityIdentification/nc:IdentificationID"/>
					</td>
				</tr>
				<tr>
					<td width="50%">Monitoring Station Name</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmMonitoringStation/nc:OrganizationName"/>
					</td>
				</tr>
				<tr>
					<td width="50%">Monitoring Station ID</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmMonitoringStation/nc:OrganizationIdentification/nc:IdentificationID"/>
					</td>
				</tr>
				<tr>
					<td width="50%">Operator ID</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmMonitoringStation/apco-alarm:AlarmMonitoringStationAugmentation/nc:PersonCurrentEmploymentAssociation/nc:EmployeeIdentification/nc:IdentificationID"/>
					</td>
				</tr>
				<tr>
					<td width="50%">Contact Number</td>
					<td width="50%"/>
				</tr>
				<tr>
					<td width="50%">IP Address</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmMonitoringStation/apco-alarm:AlarmMonitoringStationAugmentation/nc:SourceIDText"/>
					</td>
				</tr>
			</tbody>
		</table>
	</p>
	<p>
		<font face="Arial" size="4">
			<strong>
				<u>PSAP</u>
			</strong>
		</font>
	</p>
	<p>
		<table width="100%" border="1">
			<tbody>
				<tr>
					<td width="50%">PSAP Name</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmEvent/em:AlarmEventDispatchAgency/nc:OrganizationName"/>
					</td>
				</tr>
				<tr>
					<td width="50%">PSAP ID Number</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmEvent/em:AlarmEventDispatchAgency/nc:OrganizationIdentification/nc:IdentificationID"/>
					</td>
				</tr>
				<tr>
					<td width="50%">PSAP Incident Number</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmEvent/apco-alarm:AlarmEventAugmentation/apco-alarm:AlarmEventDispatchActivity/nc:ActivityIdentification/nc:IdentificationID"/>
					</td>
				</tr>
				<tr>
					<td width="50%"/>
					<td width="50%"/>
				</tr>
			</tbody>
		</table>
	</p>
	<p>
		<strong>
			<u>
				<font face="Arial" size="4">Service Location (Address)</font>
			</u>
		</strong>
	</p>
	<p>
		<table width="100%" border="1">
			<tbody>
				<tr>
					<td width="50%">Location Type</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmEvent/em:AlarmEventLocationCategoryText"/>
					</td>
				</tr>
				<tr>
					<td width="50%">Directions</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmServiceLocation/em:AlarmEventLocationAugmentation/em:LocationDirectionsText"/>
					</td>
				</tr>
				<tr>
					<td width="50%">Cross Street</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmServiceLocation/nc:LocationCrossStreet/nc:CrossStreetDescriptionText"/>
					</td>
				</tr>
				<tr>
					<td width="50%">Street</td>
					<td width="50%">
						<p>
							<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmServiceLocation/nc:LocationAddress/nc:StructuredAddress/nc:LocationStreet/nc:StreetNumberText"/><![CDATA[ ]]>
							<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmServiceLocation/nc:LocationAddress/nc:StructuredAddress/nc:LocationStreet/nc:StreetPredirectionalText"/><![CDATA[ ]]>
							<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmServiceLocation/nc:LocationAddress/nc:StructuredAddress/nc:LocationStreet/nc:StreetName"/><![CDATA[ ]]>
							<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmServiceLocation/nc:LocationAddress/nc:StructuredAddress/nc:LocationStreet/nc:StreetCategoryText"/>
						</p>
						<p>Suite 
							<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmServiceLocation/nc:LocationAddress/nc:StructuredAddress/nc:AddressSecondaryUnitText"/>
						</p>
					</td>
				</tr>
				<tr>
					<td width="50%">City</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmServiceLocation/nc:LocationAddress/nc:StructuredAddress/nc:LocationCityName"/>
					</td>
				</tr>
				<tr>
					<td width="50%">State, Postal Code</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmServiceLocation/nc:LocationAddress/nc:StructuredAddress/nc:LocationStateName"/><![CDATA[ ]]>
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmServiceLocation/nc:LocationAddress/nc:StructuredAddress/nc:LocationPostalCode"/>
					</td>
				</tr>
			</tbody>
		</table>
	</p>
	<p>
		<strong>
			<u>
				<font face="Arial" size="4">Subscriber</font>
			</u>
		</strong>
	</p>
	<p>
		<table width="100%" border="1">
			<tbody>
				<tr>
					<td width="50%">Name</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/nc:Person/nc:PersonName/nc:PersonGivenName"/><![CDATA[ ]]>
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/nc:Person/nc:PersonName/nc:PersonMiddleName"/><![CDATA[ ]]>
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/nc:Person/nc:PersonName/nc:PersonSurName"/>
					</td>
				</tr>
				<tr>
					<td width="50%">Permit Number</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmEvent/em:AlarmEventPermit/em:PermitIdentification/nc:IdentificationID"/>
					</td>
				</tr>
				<tr>
					<td width="50%">Permit Type</td>
					<td width="50%">
						<xsl:value-of select="apco-alarm:ExternalAlarm/apco-alarm:AlarmPayload/apco-alarm:AlarmEvent/em:AlarmEventPermit/em:PermitCategoryText"/>
					</td>
				</tr>
			</tbody>
		</table>
	</p>
</xsl:template>

</xsl:stylesheet><!-- Stylus Studio meta-information - (c) 2004-2006. Progress Software Corporation. All rights reserved.
<metaInformation>
<scenarios ><scenario default="yes" name="Scenario1" userelativepaths="yes" externalpreview="no" url="scenario1_new_alarm.xml" htmlbaseurl="" outputurl="" processortype="internal" useresolver="yes" profilemode="0" profiledepth="" profilelength="" urlprofilexml="" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext="" validateoutput="no" validator="internal" customvalidator=""/></scenarios><MapperMetaTag><MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/><MapperBlockPosition></MapperBlockPosition><TemplateContext></TemplateContext><MapperFilter side="source"></MapperFilter></MapperMetaTag>
</metaInformation>
-->